------------------------------------------------------------------------------
-- Explore Clip Directory, Revision 1.1
--
-- tool script
--
-- This script will explore the directory of the currently active clip in a loader
-- / saver / FBX file.  This saves precious seconds with which you can do other things, 
-- like follow strangely obtuse directions from project supervisors.
--
-- written by : Sean Konrad (sean@eyeonline.com)
-- written    : Oct. 17th, 2005
-- updated    : Dec. 2nd, 2010 (added support for FBX Exporter)
------------------------------------------------------------------------------

-- Get the tool's attributes
attrs = tool:GetAttrs()

-- Check to see if the RegID is equal to Loader or Saver.. Otherwise they don't 
-- have clips that you can explore.  
supportedIDs = {Loader = true, Saver = true, SurfaceFBXMesh = true, ExporterFBX = true}
if supportedIDs[attrs.TOOLS_RegID] then
	if attrs.TOOLS_RegID == "SurfaceFBXMesh" then
		if tool.ImportFile[comp.CurrentTime] == "" then
			-- tell them that it's set to ""
			print("No FBX to explore")
			return
		end
		executebg("explorer \""..eyeon.parseFilename(MapPath(tool.ImportFile[comp.CurrentTime])).Path.."\"")
	elseif attrs.TOOLS_RegID == "ExporterFBX" then
		if tool.Filename[comp.CurrentTime] == "" then
			-- tell them that it's set to ""
			print("No FBX to explore")
			return
		end
		executebg("explorer \""..eyeon.parseFilename(MapPath(tool.Filename[comp.CurrentTime])).Path.."\"")
	else
		-- Check to see if the clip is set to ""
		if tool.Clip[comp.CurrentTime] == "" then
			-- tell them that it's set to ""
			print("No Clip to explore")
			return
		end
		-- Explore the directory.
		executebg("explorer \""..eyeon.parseFilename(MapPath(tool.Clip[comp.CurrentTime])).Path.."\"")
	end
else
	-- Tell the user they've tried to run the script on a tool that is not acceptable
	print("This is not a Loader/Saver/FBX mesh -- this script must be run on a tool with a \"Clip\" or \"ImportFile\" property.  Unacceptable!")
end

-- Ta-da.
